@REM
@REM  usage:    make_ca.cmd server-name cert-bits
@REM
@REM  server-name    is DNS name of server.
@REM  cert-bits      is number of bits for certificate, e.g. 128, 256, 512, 1024, 2048
@REM
@REM
@REM  output files:
@REM    server-name.key        (your key generated from random.data)
@REM    server-name.de.key     (your key with pass code removed)
@REM    server-name.csr        (send this file only to certificate authority to order real CA certificate)
@REM    surge_priv.pem         (self signed & ready to use certificates for surgeftp)
@REM    surge_cert.pem         (self signed & ready to use certificates for surgeftp)

if exist random.data goto generate

@echo Please create a file called random.data that has random 
@echo information in it (at least 2MB uncompressed or 50KB compressed), 
@echo it can be anything! but must be unique data.
@echo We recomend creating large bitmap file with Paint.exe, 
@echo maybe start with existing picture, draw lots of scriggles 
@echo on it in different colors, save it as random.bmp, 
@echo compress it with pkzip or arj or compress
@echo or ace or any compresser you have.
@echo then save final file as random.data
@echo and then rerun surgeftp_ca
@pause
goto end

:generate

@REM   Generate the Key (from random number)
openssl genrsa -des3 -rand random.data -out %1.key %2

@REM   Generate Certificate Request 
openssl req -config ./openssl.cnf -new -key %1.key -out %1.csr

@REM   Generate a temporary self-signed Certificate
openssl x509 -req -days 365 -in %1.csr -signkey %1.key -out %1.crt

@REM   remove passcode encryption (SurgeFTP does not currently have option for decoding this)
openssl rsa -in %1.key -out %1.de.key

@REM   install self signed key and certificate to SurgeFTP.
@copy %1.de.key surge_priv.pem
@copy %1.crt surge_cert.pem

:end
